Attribute VB_Name = "mdPlaneThroughObjects"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function PlaneThroughObjects(firstGeometry As aGeometric, secondGeometry As aGeometric, workplaneName As String, sketchName As String, bNoSketch As Boolean, color As Long)

'Convenience Function to create a workplane passing through two faces or edges

'check if the selected topologies belong to a TopologyClass
If firstGeometry Is Nothing Then
    MsgBox ("First Edge not Selected")
Else
    Dim blnFirstGeometry As Boolean
    blnFirstGeometry = firstGeometry.IsA("Geometric")
End If

If secondGeometry Is Nothing Then
    MsgBox ("Second Edge not Selected")
Else
    Dim blnSecondGeometry As Boolean
    blnSecondGeometry = secondGeometry.IsA("Geometric")
End If

If (blnFirstGeometry And blnSecondGeometry) Then
    
    'Get the ProDESKTOP Application object
    GetApplicationObject
    
    'Get the active part document
    Dim Part As PartDocument
    Set Part = app.GetActiveDoc
    
    'Get the design
    Dim Design As aDesign
    Set Design = Part.GetDesign
    
    'Create a CommonPlane
    Dim common As zCommonPlane
    Set common = app.GetClass("CommonPlane").CreateCommonPlane
    
    Dim geom1 As zGeometry
    Dim geom2 As zGeometry
    Set geom1 = firstGeometry.GetGeometry.Clone
    Set geom2 = secondGeometry.GetGeometry.Clone
    
    'Add the geomtries to the common plane
    common.AddMember geom1
    common.AddMember geom2
    
    'Check if a workplane of the given name already exists
    Dim Found As Boolean
    Found = False

    Dim currentWorkplane As aWorkplane
    Set currentWorkplane = Part.LookupWorkplane(workplaneName)

    If Not currentWorkplane Is Nothing Then
        Found = True
    End If

    If Found Then
        MsgBox ("A workplane already exists with that name. Choose another name")
        Set PlaneThroughObjects = Nothing
        GoTo 1000
    Else
    'Create the PlaneThroughObjects workplane
    Set PlaneThroughObjects = Part.GetDesign.CreateWorkplane(common, workplaneName)
    
    End If

    'Set the Local Origin
    Dim identity As zMatrix
    Set identity = app.GetClass("Matrix").CreateScaleMatrix(1)
    Dim box As zBox
    Set box = common.GetBoundingBox(identity)
    bIsEmpty = box.IsEmpty()
    
    If Not bIsEmpty Then
        PlaneThroughObjects.SetLocalOrigin box.GetCenter
    End If
    
    'Create a sketch with the given sketch name
    If Not bNoSketch Then
    
        Dim PlaneThroughObjectsSketch As aSketch
        Set PlaneThroughObjectsSketch = PlaneThroughObjects.CreateSketch(sketchName)
        Part.SetActiveSketch PlaneThroughObjectsSketch
        
        'Set the color for the sketch
        If color < 0 Or color > 11 Then
            color = 4
        End If
        
        Dim colorCls As ColorClass
        Dim newColor As zColor
        Set colorCls = app.GetClass("Color")
        Set newColor = colorCls.CreateColor(1, color * 30, 0.35, 1)
        
        PlaneThroughObjectsSketch.SetColor newColor
    
    End If
   
Else

    MsgBox ("ImProper Selection of Entities")
    Set PlaneThroughObjects = Nothing

End If

1000:
End Function
